using System;
using System.Collections;
using UnityEngine;
using UnityEngine.Networking;

public class TestVVOX : MonoBehaviour
{
    private VoiceVoxConnection _voiceVoxConnection;
    private AudioSource audioSource;
    public string VVOXurl = "http://127.0.0.1:50021";   // [JVVOXURL;
    public int speakerID = 3;                           //񂾂
    public string testMessage = "ɂ́I񂾂łI";

    // Start is called before the first frame update
    void Start()
    {
        audioSource = gameObject.GetComponent<AudioSource>();
        _voiceVoxConnection = new VoiceVoxConnection();
        _voiceVoxConnection._speaker = speakerID;
        _voiceVoxConnection._voiceVoxUrl = VVOXurl;

        if (testMessage.Length>0) {
            // R[`gpĔ񓯊Ăяo
            StartCoroutine(TranslateTextToAudioClip(testMessage));
        }
    }

    private IEnumerator TranslateTextToAudioClip(string text)
    {
        AudioClip clip = null;

        // VoiceVoxConnectioñR[`s
        yield return StartCoroutine(_voiceVoxConnection.TranslateTextToAudioClip(text, result =>
        {
            clip = result;
        }));

        if (clip != null)
        {
            audioSource.clip = clip;
            audioSource.Play();
        }
        else
        {
            Debug.LogError("AudioClip is null");
        }
    }
}

public class VoiceVoxConnection
{
    public  string _voiceVoxUrl;
    public  int _speaker;

    public VoiceVoxConnection()
    {

    }

    public IEnumerator TranslateTextToAudioClip(string text, Action<AudioClip> callback)
    {
        string queryJson = null;

        // Audio Query 擾
        yield return SendAudioQuery(text, result =>
        {
            queryJson = result;
        });

        if (string.IsNullOrEmpty(queryJson))
        {
            Debug.LogError("Failed to get audio query");
            callback(null);
            yield break;
        }

        // Audio Clip 擾
        yield return GetAudioClip(queryJson, clip =>
        {
            callback(clip);
        });
    }

    private IEnumerator SendAudioQuery(string text, Action<string> callback)
    {
        var form = new WWWForm();
        using UnityWebRequest request = UnityWebRequest.Post($"{_voiceVoxUrl}/audio_query?text={text}&speaker={_speaker}", form);

        yield return request.SendWebRequest();

        if (request.result == UnityWebRequest.Result.ConnectionError || request.result == UnityWebRequest.Result.ProtocolError)
        {
            Debug.LogError(request.error);
            callback(null);
        }
        else
        {
            callback(request.downloadHandler.text);
        }
    }

    private IEnumerator GetAudioClip(string queryJson, Action<AudioClip> callback)
    {
        var url = $"{_voiceVoxUrl}/synthesis?speaker={_speaker}";
        using UnityWebRequest req = new UnityWebRequest(url, "POST")
        {
            uploadHandler = new UploadHandlerRaw(System.Text.Encoding.UTF8.GetBytes(queryJson)),
            downloadHandler = new DownloadHandlerBuffer()
        };

        req.SetRequestHeader("Content-Type", "application/json");

        yield return req.SendWebRequest();

        if (req.result == UnityWebRequest.Result.ConnectionError || req.result == UnityWebRequest.Result.ProtocolError)
        {
            Debug.LogError(req.error);
            callback(null);
        }
        else
        {
            callback(WavUtility.ToAudioClip(req.downloadHandler.data));
        }
    }

    public static AudioClip ToAudioClip(byte[] data)
    {
        // wb_[
        int channels = data[22];
        int frequency = BitConverter.ToInt32(data, 24);
        int length = data.Length - 44;
        float[] samples = new float[length / 2];

        // g`f[^
        for (int i = 0; i < length / 2; i++)
        {
            short value = BitConverter.ToInt16(data, i * 2 + 44);
            samples[i] = value / 32768f;
        }

        // AudioClip쐬
        AudioClip audioClip = AudioClip.Create("AudioClip", samples.Length, channels, frequency, false);
        audioClip.SetData(samples, 0);

        return audioClip;
    }
}
