using System;
using System.Collections.Generic;
using System.Text;
using UnityEngine;
using UnityEngine.Networking;
using UnityEngine.UI;


public class SimpleChat : MonoBehaviour
{
    #region KvȃNX̒`Ȃ
    [System.Serializable]
    public class MessageModel
    {
        public string role;
        public string content;
    }
    [System.Serializable]
    public class CompletionRequestModel
    {
        public string model;
        public List<MessageModel> messages;
    }

    [System.Serializable]
    public class ChatGPTRecieveModel
    {
        public string id;
        public string @object;
        public int created;
        public Choice[] choices;
        public Usage usage;

        [System.Serializable]
        public class Choice
        {
            public int index;
            public MessageModel message;
            public string finish_reason;
        }

        [System.Serializable]
        public class Usage
        {
            public int prompt_tokens;
            public int completion_tokens;
            public int total_tokens;
        }
    }
    #endregion

    public InputField IF1;  //͗pInputField
    public InputField IF2;  //o͗pInputField
    public string apiKey = "your_apiKey";
    [SerializeField, TextArea(3, 10)] public string systemstr = "Ȃ̓AXJݏZ̏qZłB";

    /*
    Ȃ̓ACIBݏZ̗RmłB
    ƂԂڂƖ{͗DiŁCrۂbŘb܂B
    negative-positivełƂlKeBuȐiłl̂́uIvłB
    uȁvu낤vu킩˂ȁvuƂ邳vƂŘb܂B
    ̔Y݂قĂACɂāA낢뎿⎆ĂBkɂ̂ĂAB
    100AW΍50Aő300xŘbĂB
     */

    private MessageModel assistantModel = new()
    {
        role = "system",
        content = "Ȃ̓AXJݏZ̏qZłB"
    };
    private List<MessageModel> communicationHistory = new();

    void Start()
    {
        assistantModel.content = systemstr;
    }

    public void Update()
    {

    }

    private void Communication(string newMessage, Action<MessageModel> result)
    {
        communicationHistory.Add(new MessageModel()
        {
            role = "user",
            content = newMessage
        });

        var apiUrl = "https://api.openai.com/v1/chat/completions";
        var jsonOptions = JsonUtility.ToJson(
            new CompletionRequestModel()
            {
                model = "gpt-4o",
                messages = communicationHistory
            }, true);
        var headers = new Dictionary<string, string>
            {
                {"Authorization", "Bearer " + apiKey},
                {"Content-type", "application/json"},
                {"X-Slack-No-Retry", "1"}
            };
        var request = new UnityWebRequest(apiUrl, "POST")
        {
            uploadHandler = new UploadHandlerRaw(Encoding.UTF8.GetBytes(jsonOptions)),
            downloadHandler = new DownloadHandlerBuffer()
        };
        foreach (var header in headers)
        {
            request.SetRequestHeader(header.Key, header.Value);
        }

        var operation = request.SendWebRequest();

        operation.completed += _ =>
        {
            if (operation.webRequest.result == UnityWebRequest.Result.ConnectionError ||
                       operation.webRequest.result == UnityWebRequest.Result.ProtocolError)
            {
                Debug.LogError(operation.webRequest.error);
                throw new Exception();
            }
            else
            {
                var responseString = operation.webRequest.downloadHandler.text;
                var responseObject = JsonUtility.FromJson<ChatGPTRecieveModel>(responseString);
                communicationHistory.Add(responseObject.choices[0].message);
                Debug.Log("assistant:" + responseObject.choices[0].message.content);
                IF2.text = responseObject.choices[0].message.content;
            }
            request.Dispose();
        };
    }

    public void MessageSubmit()
    {
        Debug.Log("user:" + IF1.text);
        communicationHistory.Add(assistantModel);
        Communication(IF1.text, (result) =>
        {
            //Debug.Log("mes3:"+result.content);
        });
    }
}